﻿using System;
using System.Text;
using System.Collections.Generic;
using Microsoft.VisualStudio.TestTools.UnitTesting;
using VeteransAffairs.Registries.BusinessManagerAHOBPR;
using VeteransAffairs.Registries.BusinessAHOBPR;
using NSubstitute;

namespace WCF_BusinessManagerAHOBPRTests
{
    /// <summary>
    /// Summary description for AHOBPRRegistrntManagerTests
    /// </summary>
    [TestClass]
    public class AHOBPRRegistrantManagerTests
    {

        private TestContext testContextInstance;

        /// <summary>
        ///Gets or sets the test context which provides
        ///information about and functionality for the current test run.
        ///</summary>
        public TestContext TestContext
        {
            get
            {
                return testContextInstance;
            }
            set
            {
                testContextInstance = value;
            }
        }

        #region Additional test attributes
        //
        // You can use the following additional attributes as you write your tests:
        //
        // Use ClassInitialize to run code before running the first test in the class
        // [ClassInitialize()]
        // public static void MyClassInitialize(TestContext testContext) { }
        //
        // Use ClassCleanup to run code after all tests in a class have run
        // [ClassCleanup()]
        // public static void MyClassCleanup() { }
        //
        // Use TestInitialize to run code before running each test 
        // [TestInitialize()]
        // public void MyTestInitialize() { }
        //
        // Use TestCleanup to run code after each test has run
        // [TestCleanup()]
        // public void MyTestCleanup() { }
        //
        #endregion

        [TestMethod()]
        public void InitializeRegistrantDBObject_Does_Not_Return_A_Null_Object()
        {
            var mockRegistrant = new REGISTRANT();
            AHOBPRRegistrantManager registrantManager = new AHOBPRRegistrantManager();
            var actual = registrantManager.InitializeRegistrantDBObject(mockRegistrant);
            Assert.IsNotNull(actual);
        }

        [TestMethod()]
        public void InitializeRegistrantDBObject_Passed_A_Non_Null_Parameter_Has_Correct_CREATED_Property()
        {
            var expected = DateTime.Now;
            var mockRegistrant = new REGISTRANT();
            mockRegistrant.CREATED = expected;
            //var registrantManager = Substitute.For<IAHOBPRRegistrantManager>();
            AHOBPRRegistrantManager registrantManager = new AHOBPRRegistrantManager();
            var actual = registrantManager.InitializeRegistrantDBObject(mockRegistrant);
            Assert.AreEqual(expected, actual.CREATED);
        }

        [TestMethod()]
        public void InitializeRegistrantDBObjectUpdatesUPDATEDPropertyOfWhenPassedANonNullParameter()
        {
            string oldDate = "2007-06-04";
            var expected = DateTime.Parse(oldDate);
            var mockRegistrant = new REGISTRANT();
            mockRegistrant.CREATED = DateTime.Now;
            mockRegistrant.UPDATED = DateTime.Parse(oldDate);

            //var registrantManager = Substitute.For<IAHOBPRRegistrantManager>();
            AHOBPRRegistrantManager registrantManager = new AHOBPRRegistrantManager();
            var actual = registrantManager.InitializeRegistrantDBObject(mockRegistrant);
            Assert.AreNotEqual(expected, actual.UPDATED);
        }
    }
}
